const express = require("express");
require("dotenv").config();
const cors = require("cors");

const orderRoutes = require("./routes/orderRoute");
const authRoutes = require("./routes/authRoute");
const paymentRoutes = require("./routes/paymentsRoute");
const chitsRoutes = require("./routes/chitsRoute");
const crackerRoutes = require("./routes/crackersRoute");
const productRoutes = require("./routes/productsRoute");
const invoiceRoutes = require("./routes/invoiceRoute"); 
const customerRoutes = require('./routes/customerRoutes');
const app = express();

app.use("/uploads", express.static("uploads"));

app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(
  cors({
    origin: "*",
    methods: ["GET", "POST", "PUT", "DELETE", "OPTIONS"],
    allowedHeaders: ["Content-Type"],
  })
);

// Use routes
app.use(authRoutes);
app.use(paymentRoutes);
app.use(chitsRoutes);
app.use(crackerRoutes);
app.use(productRoutes);
app.use(orderRoutes);
app.use(invoiceRoutes);
app.use(customerRoutes);

app.use((req, res, next) => {
  res.status(404).json({
    success: false,
    message: 'Route not found'
  });
});


app.use((error, req, res, next) => {
  console.error("Error Stack:", error.stack);
  res.status(500).json({
    success: false,
    message: "Internal server error",
  });
});

const PORT = process.env.PORT || 4000;
const Host=process.env.Host || "http://localhost:";
app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`);
});
